# -*- coding: utf-8 -*-

import sys, email, smtplib
from datetime import datetime
from models import MailingList
import config

class Sendmail():
    
    def __init__(self, mailing_list):
        if not isinstance(mailing_list, MailingList):
            raise ValueError(mailing_list, ' is not a valid mailing list')
        self.mailing_list = mailing_list
        self.suscriptors = self.mailing_list.members_addresses
        self.reply_address = self.mailing_list.address
        self.queue = []
        self.archive = self.mailing_list.config.get('archive',
                                                    config.storage_path)
        
    def get_raw_email():
        try:        
            raw_email = sys.stdin.read()
        except:
            raise IOError('Can not get a valid email from stdin')
        return raw_email

    def save_raw_email():
        filename = os.path.join(self.archive,
                                datetime.today().strftime('%Y%d%m%H%M%S%f'))
        tmpfile = file(filename, 'w')
        tmpfile.write(raw_email)
        tmpfile.close()
        self.queue.append(filename)

    def send_email():
        if not self.queue:
            raise ValueError('The emails queue is empty')
        next_email = self.queue.pop()
        email_file = file(next_email, 'r')
        email_data = email.message_from_file(email_file)
        email_file.close()

        email_data['Reply-to'] = self.reply_address

        smtp_conn = smtplib.SMTP()
        smtp_conn.connect()
        smtp_conn.sendmail(email_data['From'], self.suscriptors,
                           email_data.as_string())
        smtp_conn.close()        
