# -*- coding: utf-8 -*-

import re

def validate_email_address(address):

    """
    This function validates a given address, returning True
    if it is a valid address, False otherwise.

    The function uses a regexp from the django project, and
    it is inspired in this snippet:

    http://djangosnippets.org/snippets/1093/
    """

    email_re = re.compile(
    r"(^[-!#$%&'*+/=?^_`{}|~0-9A-Z]+(\.[-!#$%&'*+/=?^_`{}|~0-9A-Z]+)*"  # dot-atom
    r'|^"([\001-\010\013\014\016-\037!#-\[\]-\177]|\\[\001-011\013\014\016-\177])*"' # quoted-string
    r')@(?:[A-Z0-9](?:[A-Z0-9-]{0,61}[A-Z0-9])?\.)+[A-Z]{2,6}\.?$', re.IGNORECASE)  # domain
    return True if email_re.match(address) else False
