# -*- coding: utf-8 -*-

import os, sys
from unittest import TestCase
from postman.mta import Sendmail
from postman.models import Member, MailingList

class TestSendmail(TestCase):
    def setUp(self):
        self.configfile = os.path.join(os.path.dirname(__file__),
                                       'postman.conf')
        self.mailing_list = MailingList('test_list', 'test_list@example.com',
                                        members={}, configfile=self.configfile)
        self.member =  Member('test@example.com')
        self.mta = Sendmail(self.mailing_list)
        self.raw_email_file = os.path.join(os.path.dirname(__file__),
                                           'sample_raw_email.txt')
        tmp_to_read = open(self.raw_email_file, 'r')
        self.raw_email = tmp_to_read.read()
        tmp_to_read.close()
        
    def test___init__(self):
        with self.assertRaises(ValueError):
            mta = Sendmail('test_list@example.com')
            mta = Sendmail(self.member)
            mta = Sendmail(None)
        mta = Sendmail(self.mailing_list)
        self.assertTrue(isinstance(mta, Sendmail))
        self.assertEqual(mta.mailing_list, self.mailing_list)
        self.assertEqual(mta.suscriptors, self.mailing_list.members_addresses)
        self.assertEqual(mta.reply_to, self.mailing_list.address)

    def test_get_raw_email(self):
        sys_stdin = sys.stdin
        sys.stdin = open(self.raw_email_file, 'r')
        self.assertEqual(self.mta.get_raw_email(),
                         self.raw_email)
        sys.stdin.close()
        with self.assertRaises(IOError):
            self.mta.get_raw_email()

    #def save_raw_email(self):
    #    sys_stdin = sys.stdin
    #    sys.stdin = open(self.raw_email_file, 'r')
    #    self.mta.save_raw_email.filename = '/tmp/postman-test-mta-save-raw-email'
    
        
        
        
            
            
        
