/*
 * Decompiled with CFR 0.152.
 */
package jscover;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jscover.MainHelper;
import jscover.filesystem.ConfigurationForFS;
import jscover.filesystem.FileSystemInstrumenter;
import jscover.server.ConfigurationForServer;
import jscover.server.WebDaemon;
import jscover.util.IoUtils;
import jscover.util.Logger;

public class Main {
    public static final String HELP_PREFIX1 = "-h";
    public static final String CHARSET_PREFIX = "encoding";
    public static final String HELP_PREFIX2 = "--help";
    public static final String VERSION_PREFIX1 = "-V";
    public static final String VERSION_PREFIX2 = "--version";
    public static final String SERVER_PREFIX = "-ws";
    public static final String FILESYSTEM_PREFIX = "-fs";
    public static final Properties properties = new Properties();
    public static String reportSrcSubDir = "original-src";
    private String manifestName = "MANIFEST.MF";
    private List<String> dependantClasses = new ArrayList<String>(){
        {
            this.add("org.mozilla.javascript.ast.AstNode");
        }
    };
    private MainHelper mainHelper = new MainHelper();
    private WebDaemon webDaemon = new WebDaemon();
    private FileSystemInstrumenter fileSystemInstrumenter = new FileSystemInstrumenter();
    private IoUtils ioUtils = IoUtils.getInstance();
    private boolean showHelp;
    private boolean showCharsets;
    private boolean printVersion;
    private boolean isServer;
    private boolean isFileSystem;
    private int exitStatus;

    void initialize() throws IOException {
        properties.load(Main.class.getResourceAsStream("configuration.properties"));
        this.checkDependantClasses();
    }

    private void checkDependantClasses() throws IOException {
        try {
            for (String dependantClass : this.dependantClasses) {
                Class.forName(dependantClass);
            }
        }
        catch (ClassNotFoundException e) {
            Manifest mf = new Manifest(this.getClass().getResourceAsStream("/META-INF/" + this.manifestName));
            Attributes mainAttributes = mf.getMainAttributes();
            String name = mainAttributes.get(Attributes.Name.IMPLEMENTATION_TITLE).toString();
            String classPathJARs = mainAttributes.get(Attributes.Name.CLASS_PATH).toString();
            String message = "%nEnsure these JARs are in the same directory as %s.jar:%n%s";
            throw new IllegalStateException(String.format(message, name, classPathJARs), e);
        }
    }

    public static void main(String[] args) throws IOException {
        new Main().runMain(args);
    }

    public void runMain(String[] args) throws IOException {
        this.parse(args);
        this.initialize();
        if (this.printVersion().booleanValue()) {
            System.out.println(this.getVersionText());
        } else if (this.isServer().booleanValue()) {
            this.runServer(args);
        } else if (this.isFileSystem()) {
            this.runFileSystem(args);
        } else if (this.showCharSets().booleanValue()) {
            System.out.println("Valid encodings:");
            SortedMap<String, Charset> charSet = Charset.availableCharsets();
            for (String charSetName : charSet.keySet()) {
                System.out.println(charSetName);
            }
            System.out.println("Default is: " + Charset.defaultCharset().name());
        } else {
            System.out.println(this.getHelpText());
        }
        if (Logger.getInstance().isLoggedException()) {
            this.exitStatus = 1;
        }
        if (this.exitStatus != 0) {
            this.mainHelper.exit(this.exitStatus);
        }
    }

    public String getHelpText() {
        return this.ioUtils.toString(this.getClass().getResourceAsStream("help.txt"));
    }

    public String getVersionText() {
        return "JSCover version: " + properties.getProperty("version");
    }

    private void runFileSystem(String[] args) {
        ConfigurationForFS configuration = ConfigurationForFS.parse(args);
        configuration.setProperties(properties);
        if (configuration.isInvalid()) {
            this.exitStatus = 1;
        }
        if (configuration.showHelp().booleanValue()) {
            System.out.println(configuration.getHelpText());
        } else {
            this.fileSystemInstrumenter.run(configuration);
        }
    }

    private void runServer(String[] args) {
        ConfigurationForServer configuration = ConfigurationForServer.parse(args);
        configuration.setProperties(properties);
        if (configuration.isInvalid()) {
            this.exitStatus = 1;
        }
        if (configuration.showHelp().booleanValue()) {
            System.out.println(configuration.getHelpText());
        } else {
            try {
                this.webDaemon.start(configuration);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Main parse(String[] args) {
        for (String arg : args) {
            if (arg.equals(HELP_PREFIX1) || arg.equals(HELP_PREFIX2)) {
                this.showHelp = true;
                continue;
            }
            if (arg.equals(VERSION_PREFIX1) || arg.equals(VERSION_PREFIX2)) {
                this.printVersion = true;
                continue;
            }
            if (arg.equals(SERVER_PREFIX)) {
                this.isServer = true;
                continue;
            }
            if (arg.equals(FILESYSTEM_PREFIX)) {
                this.isFileSystem = true;
                continue;
            }
            if (!arg.equals(CHARSET_PREFIX)) continue;
            this.showCharsets = true;
        }
        if (!this.validOptions()) {
            this.exitStatus = 1;
            this.showHelp = true;
        }
        return this;
    }

    private boolean validOptions() {
        if (this.isServer && this.isFileSystem) {
            return false;
        }
        return this.isServer || this.isFileSystem || this.showHelp || this.printVersion || this.showCharsets;
    }

    public Boolean printVersion() {
        return this.printVersion;
    }

    public Boolean showHelp() {
        return this.showHelp;
    }

    public Boolean showCharSets() {
        return this.showHelp && this.showCharsets;
    }

    public Boolean isServer() {
        return this.isServer;
    }

    public boolean isFileSystem() {
        return this.isFileSystem;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }
}

