/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import jscover.instrument.BranchStatementBuilder;
import jscover.instrument.PostProcess;
import jscover.util.Logger;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;

public class BranchInstrumentor
implements NodeVisitor {
    private static final String initBranchLine = "  _$jscoverage['%s'].branchData[%d] = [];\n";
    private static final String initBranchCondition = "  _$jscoverage['%s'].branchData[%d][%d] = new BranchData();\n";
    private static int functionId = 1;
    private BranchStatementBuilder branchStatementBuilder = new BranchStatementBuilder();
    private Set<PostProcess> postProcesses = new HashSet<PostProcess>();
    private String uri;
    private AstRoot astRoot;
    private Logger logger = Logger.getInstance();
    private SortedMap<Integer, SortedSet<Integer>> lineConditionMap = new TreeMap<Integer, SortedSet<Integer>>();

    public BranchInstrumentor(String uri) {
        this.uri = uri;
    }

    public void setAstRoot(AstRoot astRoot) {
        this.astRoot = astRoot;
    }

    public void postProcess() {
        for (PostProcess postProcess : this.postProcesses) {
            postProcess.process();
        }
    }

    private void replaceWithFunction(AstNode node) {
        AstNode parent = node.getParent();
        Integer conditionId = 1;
        TreeSet<Integer> conditions = (TreeSet<Integer>)this.lineConditionMap.get(node.getLineno());
        if (conditions == null) {
            conditions = new TreeSet<Integer>();
            this.lineConditionMap.put(node.getLineno(), conditions);
        } else {
            conditionId = (Integer)conditions.last() + 1;
        }
        conditions.add(conditionId);
        FunctionNode functionNode = this.branchStatementBuilder.buildBranchRecordingFunction(this.uri, functionId++, node.getLineno(), conditionId);
        this.astRoot.addChildrenToFront(functionNode);
        ExpressionStatement conditionArrayDeclaration = this.branchStatementBuilder.buildLineAndConditionInitialisation(this.uri, node.getLineno(), conditionId, this.getLinePosition(node), node.getLength(), node.toSource());
        this.astRoot.addChildrenToFront(conditionArrayDeclaration);
        FunctionCall functionCall = new FunctionCall();
        ArrayList<AstNode> arguments = new ArrayList<AstNode>();
        functionCall.setTarget(functionNode.getFunctionName());
        arguments.add(node);
        functionCall.setArguments(arguments);
        if (parent instanceof IfStatement && node == ((IfStatement)parent).getCondition()) {
            ((IfStatement)parent).setCondition(functionCall);
        } else if (parent instanceof ParenthesizedExpression) {
            ((ParenthesizedExpression)parent).setExpression(functionCall);
        } else if (parent instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)parent;
            if (infixExpression.getLeft() == node) {
                infixExpression.setLeft(functionCall);
            } else {
                infixExpression.setRight(functionCall);
            }
        } else if (parent instanceof ReturnStatement) {
            ((ReturnStatement)parent).setReturnValue(functionCall);
        } else if (parent instanceof VariableInitializer) {
            ((VariableInitializer)parent).setInitializer(functionCall);
        } else if (parent instanceof WhileLoop) {
            ((WhileLoop)parent).setCondition(functionCall);
        } else if (parent instanceof DoLoop) {
            ((DoLoop)parent).setCondition(functionCall);
        } else if (parent instanceof ForLoop) {
            ((ForLoop)parent).setCondition(functionCall);
        } else if (parent instanceof ElementGet) {
            ((ElementGet)parent).setElement(functionCall);
        } else if (parent instanceof ExpressionStatement) {
            ((ExpressionStatement)parent).setExpression(functionCall);
        } else if (parent instanceof ConditionalExpression) {
            ConditionalExpression ternary = (ConditionalExpression)parent;
            if (ternary.getTestExpression() == node) {
                ternary.setTestExpression(functionCall);
            } else if (ternary.getTrueExpression() == node) {
                ternary.setTrueExpression(functionCall);
            } else {
                ternary.setFalseExpression(functionCall);
            }
        } else if (parent instanceof ArrayLiteral) {
            this.postProcesses.add(new PostProcess(parent, node, functionCall){

                @Override
                void run(AstNode parent, AstNode node, AstNode functionCall) {
                    ArrayLiteral arrayParent = (ArrayLiteral)parent;
                    List<AstNode> elements = arrayParent.getElements();
                    ArrayList<AstNode> newElements = new ArrayList<AstNode>();
                    for (AstNode element : elements) {
                        if (element == node) {
                            newElements.add(functionCall);
                            continue;
                        }
                        newElements.add(element);
                    }
                    arrayParent.setElements(newElements);
                }
            });
        } else if (parent instanceof FunctionCall) {
            this.postProcesses.add(new PostProcess(parent, node, functionCall){

                @Override
                void run(AstNode parent, AstNode node, AstNode functionCall) {
                    FunctionCall fnParent = (FunctionCall)parent;
                    List<AstNode> fnParentArguments = fnParent.getArguments();
                    ArrayList<AstNode> newFnParentArguments = new ArrayList<AstNode>();
                    for (AstNode arg : fnParentArguments) {
                        if (arg == node) {
                            newFnParentArguments.add(functionCall);
                            continue;
                        }
                        newFnParentArguments.add(arg);
                    }
                    fnParent.setArguments(newFnParentArguments);
                }
            });
        } else {
            this.logger.log(String.format("Couldn't insert wrapper for parent %s, file: %s, line: %d, position: %d, source: %s", parent.getClass().getName(), this.uri, node.getLineno(), node.getPosition(), node.toSource()));
        }
    }

    @Override
    public boolean visit(AstNode node) {
        if (this.isBoolean(node)) {
            this.replaceWithFunction(node);
        }
        return true;
    }

    private boolean isBoolean(AstNode node) {
        switch (node.getType()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 46: 
            case 47: 
            case 104: 
            case 105: {
                return true;
            }
        }
        if (node.getParent() instanceof IfStatement) {
            return this.wrapNonInfixIfCondition((IfStatement)node.getParent(), node);
        }
        return false;
    }

    private boolean wrapNonInfixIfCondition(IfStatement parent, AstNode node) {
        if (parent.getCondition() != node) {
            return false;
        }
        return !(node instanceof ParenthesizedExpression);
    }

    public int getLinePosition(AstNode node) {
        int pos = node.getPosition();
        for (AstNode parent = node.getParent(); parent != null && parent.getLineno() == node.getLineno(); parent = parent.getParent()) {
            pos += parent.getPosition();
        }
        return pos - 1;
    }

    protected String getJsLineInitialization() {
        StringBuilder sb = new StringBuilder(String.format("if (! _$jscoverage['%s'].branchData) {\n", this.uri));
        sb.append(String.format("  _$jscoverage['%s'].branchData = [];\n", this.uri));
        for (Integer line : this.lineConditionMap.keySet()) {
            sb.append(String.format(initBranchLine, this.uri, line));
            for (Integer condition : (SortedSet)this.lineConditionMap.get(line)) {
                sb.append(String.format(initBranchCondition, this.uri, line, condition));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }
}

