/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import jscover.instrument.SourceProcessor;
import jscover.server.UriNotFound;
import jscover.util.IoUtils;
import org.mozilla.javascript.CompilerEnvirons;

public class InstrumenterService {
    private IoUtils ioUtils = IoUtils.getInstance();

    public String instrumentJSForWebServer(CompilerEnvirons compilerEnvirons, File srcFile, String uri, boolean includeBranch) {
        SourceProcessor sourceProcessor = new SourceProcessor(compilerEnvirons, uri, includeBranch);
        try {
            String source = this.ioUtils.toString(new FileInputStream(srcFile));
            return sourceProcessor.processSourceForServer(source);
        }
        catch (FileNotFoundException e) {
            throw new UriNotFound("Couldn't find " + uri, e);
        }
    }

    public String instrumentJSForWebServer(CompilerEnvirons compilerEnvirons, String source, String uri, boolean includeBranch) {
        SourceProcessor sourceProcessor = new SourceProcessor(compilerEnvirons, uri, includeBranch);
        return sourceProcessor.processSourceForServer(source);
    }

    public void instrumentJSForFileSystem(CompilerEnvirons compilerEnvirons, File srcFile, File dest, String uri, boolean includeBranch) {
        SourceProcessor sourceProcessor = new SourceProcessor(compilerEnvirons, uri, includeBranch);
        String source = this.ioUtils.loadFromFileSystem(srcFile);
        String jsInstrumented = sourceProcessor.processSourceForFileSystem(source);
        this.ioUtils.copy(jsInstrumented, dest);
    }
}

