/*
 * Decompiled with CFR 0.152.
 */
package jscover.report;

import java.io.File;
import java.io.IOException;
import java.util.SortedMap;
import jscover.MainHelper;
import jscover.report.ConfigurationForReport;
import jscover.report.FileData;
import jscover.report.JSONDataMerger;
import jscover.report.ReportFormat;
import jscover.report.SummaryData;
import jscover.report.lcov.LCovGenerator;
import jscover.report.xml.XMLSummary;
import jscover.util.IoUtils;

public class Main {
    private MainHelper mainHelper = new MainHelper();
    private XMLSummary xmlSummary = new XMLSummary();
    private LCovGenerator lCovGenerator = new LCovGenerator();
    private JSONDataMerger jsonDataMerger = new JSONDataMerger();
    private IoUtils ioUtils = IoUtils.getInstance();
    private ConfigurationForReport config = new ConfigurationForReport();

    public static void main(String[] args) throws IOException {
        new Main().runMain(args);
    }

    void runMain(String[] args) throws IOException {
        this.config.parse(args);
        if (this.config.isInvalid()) {
            System.out.println(this.config.getHelpText());
            this.mainHelper.exit(1);
        } else if (this.config.showHelp().booleanValue()) {
            System.out.println(this.config.getHelpText());
        } else if (this.config.getReportFormat() == ReportFormat.LCOV) {
            this.generateLCovDataFile();
        } else if (this.config.getReportFormat() == ReportFormat.XMLSUMMARY) {
            this.saveXmlSummary();
        } else if (this.config.isMerge()) {
            this.mergeReports();
        } else {
            System.out.println(this.config.getHelpText());
            this.mainHelper.exit(1);
        }
    }

    private void mergeReports() {
        String[] data = new String[this.config.getMergeDirs().size()];
        for (int i = 0; i < data.length; ++i) {
            File dataFile = new File(this.config.getMergeDirs().get(i), "jscoverage.json");
            data[i] = this.ioUtils.loadFromFileSystem(dataFile);
        }
        SortedMap<String, FileData> mergedMap = this.jsonDataMerger.mergeJSONCoverageStrings(data);
        this.ioUtils.mkdirs(this.config.getMergeDestDir());
        File mergedJson = new File(this.config.getMergeDestDir(), "jscoverage.json");
        this.ioUtils.copy(this.jsonDataMerger.toJSON(mergedMap), mergedJson);
        File firstReportDir = this.config.getMergeDirs().get(0);
        File srcDir = new File(this.config.getMergeDestDir(), jscover.Main.reportSrcSubDir);
        this.ioUtils.copyDir(firstReportDir, this.config.getMergeDestDir());
        for (int i = 1; i < this.config.getMergeDirs().size(); ++i) {
            this.ioUtils.copyDir(new File(this.config.getMergeDirs().get(i), jscover.Main.reportSrcSubDir), srcDir);
        }
    }

    private void generateLCovDataFile() throws IOException {
        String json = this.ioUtils.loadFromFileSystem(new File(this.config.getJsonDirectory(), "jscoverage.json"));
        File lcovFile = new File(this.config.getJsonDirectory(), "jscover.lcov");
        this.lCovGenerator.saveData(this.jsonDataMerger.jsonToMap(json).values(), this.config.getSourceDirectory().getCanonicalPath(), lcovFile);
    }

    private void saveXmlSummary() {
        String json = this.ioUtils.loadFromFileSystem(new File(this.config.getJsonDirectory(), "jscoverage.json"));
        SummaryData summaryData = new SummaryData(this.jsonDataMerger.jsonToMap(json).values());
        this.xmlSummary.saveSummary(summaryData, this.config.getJsonDirectory(), "version");
    }
}

