/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jscover.Main;
import jscover.instrument.InstrumenterService;
import jscover.instrument.UnloadedSourceProcessor;
import jscover.report.JSONDataSaver;
import jscover.report.ScriptLinesAndSource;
import jscover.server.ConfigurationForServer;
import jscover.server.HTTP_STATUS;
import jscover.server.HttpRequest;
import jscover.server.HttpServer;
import jscover.server.MIME;
import jscover.server.ProxyService;
import jscover.server.UriNotFound;
import jscover.util.IoService;
import jscover.util.Logger;

public class InstrumentingRequestHandler
extends HttpServer {
    public static final String JSCOVERAGE_STORE = "/jscoverage-store";
    static Set<String> uris = new HashSet<String>();
    private ConfigurationForServer configuration;
    private IoService ioService = new IoService();
    private JSONDataSaver jsonDataSaver = new JSONDataSaver();
    private InstrumenterService instrumenterService = new InstrumenterService();
    private ProxyService proxyService = new ProxyService();
    private UnloadedSourceProcessor unloadedSourceProcessor;
    private Logger logger;

    public InstrumentingRequestHandler(Socket socket, ConfigurationForServer configuration) {
        super(socket, configuration.getDocumentRoot(), configuration.getVersion());
        this.configuration = configuration;
        this.unloadedSourceProcessor = new UnloadedSourceProcessor(configuration);
    }

    @Override
    protected void handlePost(HttpRequest request, String data) {
        String uri = request.getPath();
        if (uri.startsWith(JSCOVERAGE_STORE)) {
            File reportDir = this.configuration.getReportDir();
            if (uri.length() > JSCOVERAGE_STORE.length()) {
                reportDir = new File(reportDir, uri.substring(JSCOVERAGE_STORE.length()));
            }
            try {
                File src;
                List<ScriptLinesAndSource> unloadJSData = null;
                if (this.configuration.isIncludeUnloadedJS()) {
                    unloadJSData = this.unloadedSourceProcessor.getEmptyCoverageData(uris);
                    for (ScriptLinesAndSource scriptLinesAndSource : unloadJSData) {
                        src = new File(this.configuration.getDocumentRoot(), scriptLinesAndSource.getUri());
                        this.ioUtils.copy(src, new File(reportDir, Main.reportSrcSubDir + scriptLinesAndSource.getUri()));
                    }
                }
                this.jsonDataSaver.saveJSONData(reportDir, data, unloadJSData);
                for (String jsURI : uris) {
                    src = new File(this.configuration.getDocumentRoot(), jsURI);
                    File dest = new File(reportDir, Main.reportSrcSubDir + "/" + jsURI);
                    this.ioUtils.copy(src, dest);
                }
                this.ioService.generateJSCoverFilesForWebServer(reportDir, this.configuration.getVersion());
                this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.TEXT_PLAIN, "Coverage data stored at " + reportDir);
            }
            catch (Throwable t) {
                this.logger.log("Error saving coverage data", t);
                String message = String.format("Error saving coverage data. Try deleting JSON file at %s\n", reportDir);
                this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.TEXT_PLAIN, message);
            }
        } else if (this.configuration.isProxy()) {
            this.proxyService.handleProxyPost(request, data, this.os);
        } else {
            super.handlePost(request, data);
        }
    }

    @Override
    protected void handleGet(HttpRequest request) throws IOException {
        String uri = request.getPath();
        try {
            if (uri.equals("/jscoverage.js")) {
                this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), this.ioService.generateJSCoverageServerJS());
            } else if (uri.startsWith("/jscoverage.html")) {
                String reportHTML = this.ioService.generateJSCoverageHtml(this.configuration.getVersion());
                this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), reportHTML);
            } else if (uri.startsWith("/jscoverage")) {
                this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), this.ioService.getResourceAsStream(uri));
            } else if (uri.endsWith(".js") && !this.configuration.skipInstrumentation(uri.substring(1)) && !request.skipInstrumentation()) {
                String jsInstrumented;
                if (this.configuration.isProxy()) {
                    String originalJS = this.proxyService.getUrl(request.getUrl());
                    jsInstrumented = this.instrumenterService.instrumentJSForWebServer(this.configuration.getCompilerEnvirons(), originalJS, uri, this.configuration.isIncludeBranch());
                } else {
                    jsInstrumented = this.instrumenterService.instrumentJSForWebServer(this.configuration.getCompilerEnvirons(), new File(this.wwwRoot, uri), uri, this.configuration.isIncludeBranch());
                    uris.add(uri.substring(1));
                }
                this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.JS, jsInstrumented);
            } else if (this.configuration.isProxy()) {
                this.proxyService.handleProxyGet(request, this.os);
            } else {
                super.handleGet(request);
            }
        }
        catch (UriNotFound e) {
            this.sendResponse(HTTP_STATUS.HTTP_FILE_NOT_FOUND, MIME.TEXT_PLAIN, e.getMessage());
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            this.sendResponse(HTTP_STATUS.HTTP_INTERNAL_SERVER_ERROR, MIME.TEXT_PLAIN, stringWriter.toString());
        }
    }

    @Override
    protected void handleHead(HttpRequest request) {
        if (this.configuration.isProxy()) {
            this.proxyService.handleProxyHead(request, this.os);
        } else {
            super.handleHead(request);
        }
    }
}

