/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.SortedSet;
import jscover.instrument.BranchInstrumentor;
import jscover.instrument.ParseTreeInstrumenter;
import jscover.util.IoUtils;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstRoot;

class SourceProcessor {
    private static final String initLine = "  _$jscoverage['%s'].lineData[%d] = 0;\n";
    private String uri;
    private ParseTreeInstrumenter instrumenter;
    private BranchInstrumentor branchInstrumentor;
    private Parser parser;
    private IoUtils ioUtils = IoUtils.getInstance();
    private boolean includeBranchCoverage;

    public SourceProcessor(CompilerEnvirons compilerEnv, String uri, boolean includeBranchCoverage) {
        this.uri = uri;
        this.instrumenter = new ParseTreeInstrumenter(uri);
        this.branchInstrumentor = new BranchInstrumentor(uri);
        this.parser = new Parser(compilerEnv);
        this.includeBranchCoverage = includeBranchCoverage;
    }

    public String processSourceForServer(String source) {
        String reportJS = this.ioUtils.loadFromClassPath("/report.js");
        return reportJS + this.processSource(this.uri, source);
    }

    public String processSourceForFileSystem(String source) {
        return this.processSource(this.uri, source);
    }

    protected String processSource(String sourceURI, String source) {
        String headerJS = this.ioUtils.loadFromClassPath("/header.js");
        String commonJS = this.ioUtils.loadFromClassPath("/jscoverage-common.js");
        String branchJS = this.ioUtils.loadFromClassPath("/jscoverage-branch.js");
        return branchJS + commonJS + headerJS + this.processSourceWithoutHeader(sourceURI, source);
    }

    protected String processSourceWithoutHeader(String source) {
        return this.processSourceWithoutHeader(this.uri, source);
    }

    protected String processSourceWithoutHeader(String sourceURI, String source) {
        String instrumentedSource = this.instrumentSource(sourceURI, source);
        String jsLineInitialization = this.getJsLineInitialization(this.uri, this.instrumenter.getValidLines());
        if (this.includeBranchCoverage) {
            jsLineInitialization = jsLineInitialization + this.branchInstrumentor.getJsLineInitialization();
        }
        return jsLineInitialization + instrumentedSource;
    }

    protected String instrumentSource(String source) {
        return this.instrumentSource(this.uri, source);
    }

    protected String instrumentSource(String sourceURI, String source) {
        AstRoot astRoot = this.parser.parse(source, sourceURI, 1);
        astRoot.visitAll(this.instrumenter);
        if (this.includeBranchCoverage) {
            this.branchInstrumentor.setAstRoot(astRoot);
            astRoot.visitAll(this.branchInstrumentor);
            this.branchInstrumentor.postProcess();
        }
        return astRoot.toSource();
    }

    protected String getJsLineInitialization(String fileName, SortedSet<Integer> validLines) {
        StringBuilder sb = new StringBuilder(String.format("if (! _$jscoverage['%s']) {\n", fileName));
        sb.append(String.format("  _$jscoverage['%s'] = {};\n", fileName));
        sb.append(String.format("  _$jscoverage['%s'].lineData = [];\n", fileName));
        for (Integer line : validLines) {
            sb.append(String.format(initLine, fileName, line));
        }
        sb.append("}\n");
        return sb.toString();
    }
}

