/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import jscover.instrument.LineCountNodeVisitor;
import jscover.report.ScriptLinesAndSource;
import jscover.server.ConfigurationForServer;
import jscover.util.FileScanner;
import jscover.util.IoUtils;
import jscover.util.Logger;

public class UnloadedSourceProcessor {
    private ConfigurationForServer config;
    private IoUtils ioUtils = IoUtils.getInstance();
    private FileScanner fileScanner;
    private Logger logger = Logger.getInstance();

    public UnloadedSourceProcessor(ConfigurationForServer config) {
        this.fileScanner = new FileScanner(config);
        this.config = config;
    }

    public List<ScriptLinesAndSource> getEmptyCoverageData(Set<String> urisAlreadyProcessed) {
        ArrayList<ScriptLinesAndSource> scripts = new ArrayList<ScriptLinesAndSource>();
        for (File file : this.fileScanner.getFiles(urisAlreadyProcessed)) {
            LineCountNodeVisitor visitor = new LineCountNodeVisitor(this.config.getCompilerEnvirons());
            String uri = this.ioUtils.getRelativePath(file, this.config.getDocumentRoot());
            String source = this.ioUtils.loadFromFileSystem(file);
            try {
                SortedSet<Integer> codeLines = visitor.getCodeLines(source);
                ScriptLinesAndSource script = new ScriptLinesAndSource("/" + uri, new ArrayList<Integer>(codeLines));
                scripts.add(script);
            }
            catch (RuntimeException t) {
                this.logger.log(String.format("Problem parsing %s", uri), t);
            }
        }
        return scripts;
    }
}

