/*
 * Decompiled with CFR 0.152.
 */
package jscover.report;

import java.util.List;
import jscover.report.BranchData;
import jscover.report.CoverageAdapter;

public class FileData
extends CoverageAdapter {
    private String uri;
    private List<Integer> lines;
    private List<List<BranchData>> branchData;
    private int codeLineCount;
    private int codeLinesCoveredCount;
    private int branchCount;
    private int branchesCoveredCount;

    public FileData(String uri, List<Integer> lines, List<List<BranchData>> branchData) {
        this.uri = uri;
        this.lines = lines;
        this.branchData = branchData;
    }

    public String getUri() {
        return this.uri;
    }

    public List<Integer> getLines() {
        return this.lines;
    }

    public void addCoverage(Integer coverage, int index) {
        this.lines.set(index, this.lines.get(index) + coverage);
    }

    public List<List<BranchData>> getBranchData() {
        return this.branchData;
    }

    @Override
    public int getCodeLineCount() {
        this.calculateLineStatistics();
        return this.codeLineCount;
    }

    @Override
    public int getCodeLinesCoveredCount() {
        this.calculateLineStatistics();
        return this.codeLinesCoveredCount;
    }

    public void calculateLineStatistics() {
        if (this.codeLineCount == 0) {
            for (int i = 1; i < this.lines.size(); ++i) {
                if (this.lines.get(i) == null) continue;
                ++this.codeLineCount;
                if (this.lines.get(i) <= 0) continue;
                ++this.codeLinesCoveredCount;
            }
        }
    }

    @Override
    public int getBranchCount() {
        this.calculateBranchStatistics();
        return this.branchCount;
    }

    @Override
    public int getBranchesCoveredCount() {
        this.calculateBranchStatistics();
        return this.branchesCoveredCount;
    }

    public void calculateBranchStatistics() {
        if (this.branchCount == 0) {
            for (int i = 1; i < this.branchData.size(); ++i) {
                List<BranchData> branchDatas = this.branchData.get(i);
                if (branchDatas == null) continue;
                for (int j = 1; j < branchDatas.size(); ++j) {
                    this.branchCount += 2;
                    BranchData data = branchDatas.get(j);
                    if (data.getEvalFalse() > 0) {
                        ++this.branchesCoveredCount;
                    }
                    if (data.getEvalTrue() <= 0) continue;
                    ++this.branchesCoveredCount;
                }
            }
        }
    }
}

