/*
 * Decompiled with CFR 0.152.
 */
package jscover.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import jscover.report.BranchData;
import jscover.report.FileData;
import jscover.report.ScriptLinesAndSource;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.json.JsonParser;

public class JSONDataMerger {
    private Context cx = Context.enter();
    private JsonParser parser = new JsonParser(this.cx, this.cx.initStandardObjects());

    public SortedMap<String, FileData> mergeJSONCoverageStrings(String ... data) {
        TreeMap<String, FileData> total = new TreeMap<String, FileData>();
        for (String json : data) {
            this.mergeJSONCoverageMaps(total, this.jsonToMap(json));
        }
        return total;
    }

    private SortedMap<String, FileData> mergeJSONCoverageMaps(SortedMap<String, FileData> map1, SortedMap<String, FileData> map2) {
        for (String scriptName : map1.keySet()) {
            int i;
            if (!map2.containsKey(scriptName)) continue;
            FileData coverageData = (FileData)map1.get(scriptName);
            for (i = 0; i < coverageData.getLines().size(); ++i) {
                if (coverageData.getLines().get(i) == null) continue;
                coverageData.addCoverage(((FileData)map2.get(scriptName)).getLines().get(i), i);
            }
            for (i = 0; i < coverageData.getBranchData().size(); ++i) {
                List<BranchData> conditions = coverageData.getBranchData().get(i);
                if (conditions == null) continue;
                for (int j = 0; j < conditions.size(); ++j) {
                    if (conditions.get(j) == null) continue;
                    conditions.get(j).addCoverage(((FileData)map2.get(scriptName)).getBranchData().get(i).get(j));
                }
            }
        }
        for (String scriptName : map2.keySet()) {
            if (map1.containsKey(scriptName)) continue;
            map1.put(scriptName, (FileData)map2.get(scriptName));
        }
        return map1;
    }

    public SortedMap<String, FileData> jsonToMap(String data) {
        TreeMap<String, FileData> map = new TreeMap<String, FileData>();
        try {
            NativeObject json = (NativeObject)this.parser.parseValue(data);
            for (Object scriptURI : json.keySet()) {
                NativeObject scriptData = (NativeObject)json.get(scriptURI);
                NativeArray lineCoverageArray = (NativeArray)scriptData.get("lineData");
                NativeArray branchJSONArray = (NativeArray)scriptData.get("branchData");
                ArrayList<Integer> countData = new ArrayList<Integer>(lineCoverageArray.size());
                for (int i = 0; i < lineCoverageArray.size(); ++i) {
                    countData.add((Integer)lineCoverageArray.get(i));
                }
                ArrayList<List<BranchData>> branchLineArray = new ArrayList<List<BranchData>>();
                if (branchJSONArray != null) {
                    this.readBranchLines(branchJSONArray, branchLineArray);
                }
                map.put((String)scriptURI, new FileData((String)scriptURI, countData, branchLineArray));
            }
        }
        catch (JsonParser.ParseException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private void readBranchLines(NativeArray branchJSONArray, List<List<BranchData>> branchLineArray) {
        for (int i = 0; i < branchJSONArray.size(); ++i) {
            ArrayList<BranchData> branchConditionArray = new ArrayList<BranchData>();
            branchLineArray.add(branchConditionArray);
            NativeArray conditionsJSON = (NativeArray)branchJSONArray.get(i);
            if (conditionsJSON == null) continue;
            this.readBranchCondition(branchConditionArray, conditionsJSON);
        }
    }

    private void readBranchCondition(List<BranchData> branchConditionArray, NativeArray conditionsJSON) {
        for (int j = 0; j < conditionsJSON.size(); ++j) {
            NativeObject conditionJSON = (NativeObject)conditionsJSON.get(j);
            if (conditionJSON == null) {
                branchConditionArray.add(null);
                continue;
            }
            int position = (Integer)conditionJSON.get("position");
            int nodeLength = (Integer)conditionJSON.get("nodeLength");
            String src = (String)conditionJSON.get("src");
            int evalFalse = (Integer)conditionJSON.get("evalFalse");
            int evalTrue = (Integer)conditionJSON.get("evalTrue");
            branchConditionArray.add(new BranchData(position, nodeLength, src, evalFalse, evalTrue));
        }
    }

    String toJSON(SortedMap<String, FileData> map) {
        StringBuilder json = new StringBuilder("{");
        int scriptCount = 0;
        for (String scriptURI : map.keySet()) {
            StringBuilder coverage = new StringBuilder();
            StringBuilder branchData = new StringBuilder();
            FileData coverageData = (FileData)map.get(scriptURI);
            for (int i = 0; i < coverageData.getLines().size(); ++i) {
                if (i > 0) {
                    coverage.append(",");
                }
                coverage.append(coverageData.getLines().get(i));
            }
            this.addBranchData(branchData, coverageData);
            if (scriptCount++ > 0) {
                json.append(",");
            }
            String scriptJSON = "\"%s\":{\"lineData\":[%s],\"branchData\":[%s]}";
            json.append(String.format(scriptJSON, scriptURI, coverage, branchData));
        }
        json.append("}");
        return json.toString();
    }

    private void addBranchData(StringBuilder branchData, FileData coverageData) {
        for (int i = 0; i < coverageData.getBranchData().size(); ++i) {
            List<BranchData> conditions;
            if (i > 0) {
                branchData.append(",");
            }
            if ((conditions = coverageData.getBranchData().get(i)).size() > 0) {
                branchData.append("[");
            } else {
                branchData.append("null");
            }
            this.addBranchConditions(branchData, conditions);
            if (conditions.size() <= 0) continue;
            branchData.append("]");
        }
    }

    private void addBranchConditions(StringBuilder branchData, List<BranchData> conditions) {
        for (int j = 0; j < conditions.size(); ++j) {
            BranchData branchObj;
            if (j > 0) {
                branchData.append(",");
            }
            if ((branchObj = conditions.get(j)) == null) {
                branchData.append("null");
                continue;
            }
            String branchJSON = "{\"position\":%d,\"nodeLength\":%d,\"src\":\"%s\",\"evalFalse\":%d,\"evalTrue\":%d}";
            String branchSource = ScriptRuntime.escapeString(branchObj.getSource());
            branchData.append(String.format(branchJSON, branchObj.getPosition(), branchObj.getNodeLength(), branchSource, branchObj.getEvalFalse(), branchObj.getEvalTrue()));
        }
    }

    public SortedMap<String, FileData> createEmptyJSON(List<ScriptLinesAndSource> scripts) {
        TreeMap<String, FileData> map = new TreeMap<String, FileData>();
        for (ScriptLinesAndSource script : scripts) {
            Integer[] lines = new Integer[script.getLines().get(script.getLines().size() - 1) + 1];
            for (int i = 0; i < script.getLines().size(); ++i) {
                lines[script.getLines().get((int)i).intValue()] = 0;
            }
            ArrayList<List<BranchData>> branchLineArray = new ArrayList<List<BranchData>>();
            FileData coverageData = new FileData(script.getUri(), Arrays.asList(lines), branchLineArray);
            map.put(script.getUri(), coverageData);
        }
        return map;
    }
}

