/*
 * Decompiled with CFR 0.152.
 */
package jscover.report.lcov;

import java.io.File;
import java.util.Collection;
import java.util.List;
import jscover.report.BranchData;
import jscover.report.FileData;
import jscover.util.IoUtils;

public class LCovGenerator {
    private IoUtils ioUtils = IoUtils.getInstance();
    private String source = "SF:%s\n";
    private String branchData = "BRDA:%d,0,%d,%s\n";
    private String lineData = "DA:%d,%d\n";
    private String endRecord = "end_of_record\n";

    public void saveData(Collection<FileData> files, String sourceDirectory, File dest) {
        StringBuilder lcov = new StringBuilder();
        for (FileData file : files) {
            lcov.append(this.generateRecord(file, sourceDirectory));
        }
        this.ioUtils.copy(lcov.toString(), dest);
    }

    String generateRecord(FileData coverageData, String sourceDirectory) {
        StringBuilder lcov = new StringBuilder();
        lcov.append(String.format(this.source, sourceDirectory.replaceAll("\\\\", "/") + coverageData.getUri()));
        this.processBranches(coverageData, lcov);
        this.processLines(coverageData, lcov);
        lcov.append(this.endRecord);
        return lcov.toString();
    }

    private void processLines(FileData coverageData, StringBuilder lcov) {
        for (int lineNumber = 0; lineNumber < coverageData.getLines().size(); ++lineNumber) {
            Integer count = coverageData.getLines().get(lineNumber);
            if (count == null) continue;
            lcov.append(String.format(this.lineData, lineNumber, count));
        }
    }

    private void processBranches(FileData coverageData, StringBuilder lcov) {
        for (int lineNumber = 0; lineNumber < coverageData.getBranchData().size(); ++lineNumber) {
            List<BranchData> conditions = coverageData.getBranchData().get(lineNumber);
            if (conditions == null) continue;
            for (int j = 0; j < conditions.size(); ++j) {
                BranchData branch = conditions.get(j);
                if (branch == null) continue;
                String taken = branch.getEvalFalse() > 0 ? "" + branch.getEvalFalse() : "-";
                lcov.append(String.format(this.branchData, lineNumber, j * 2 - 1, taken));
                taken = branch.getEvalTrue() > 0 ? "" + branch.getEvalTrue() : "-";
                lcov.append(String.format(this.branchData, lineNumber, j * 2, taken));
            }
        }
    }
}

