/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import jscover.server.HTTP_STATUS;
import jscover.server.HttpRequest;
import jscover.server.MIME;
import jscover.util.IoUtils;

public class HttpServer
extends Thread {
    private Socket socket;
    private String version;
    protected File wwwRoot;
    protected InputStream is;
    protected OutputStream os;
    protected PrintWriter pw = null;
    protected IoUtils ioUtils = IoUtils.getInstance();

    public HttpServer(Socket socket, File wwwRoot, String version) {
        this.wwwRoot = wwwRoot;
        this.socket = socket;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader br = null;
        try {
            String headerLine;
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
            br = new BufferedReader(new InputStreamReader(this.is));
            this.pw = new PrintWriter(this.os);
            String requestString = br.readLine();
            StringTokenizer tokenizer = new StringTokenizer(requestString);
            String httpMethod = tokenizer.nextToken();
            HttpRequest httpRequest = new HttpRequest(tokenizer.nextToken());
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            while (!(headerLine = br.readLine()).equals("")) {
                int index = headerLine.indexOf(58);
                if (index < 0) continue;
                String headerField = headerLine.substring(0, index).trim();
                String headerValue = headerLine.substring(index + 1).trim();
                if (!headers.containsKey(headerField)) {
                    headers.put(headerField, new ArrayList());
                }
                ((List)headers.get(headerField)).add(headerValue);
            }
            httpRequest.setHeaders(headers);
            if (httpMethod.equals("GET")) {
                if (httpRequest.getPath().equals("/stop")) {
                    this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.TEXT_PLAIN, "Shutting down the server.");
                    this.ioUtils.closeQuietly(br);
                    this.ioUtils.closeQuietly(this.os);
                    System.exit(0);
                }
                this.handleGet(httpRequest);
            } else if (httpMethod.equals("HEAD")) {
                this.handleHead(httpRequest);
            } else if (httpMethod.equals("POST")) {
                int length = Integer.valueOf((String)((List)headers.get("Content-Length")).get(0));
                this.handlePost(httpRequest, this.ioUtils.toStringNoClose(br, length));
            } else {
                throw new UnsupportedOperationException("No support for " + httpMethod);
            }
            this.ioUtils.closeQuietly(br);
            this.ioUtils.closeQuietly(this.os);
            this.ioUtils.closeQuietly(this.socket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.ioUtils.closeQuietly(br);
            this.ioUtils.closeQuietly(this.os);
            this.ioUtils.closeQuietly(this.socket);
        }
    }

    protected void handleHead(HttpRequest httpRequest) {
        throw new UnsupportedOperationException("No support for HEAD");
    }

    protected void handlePost(HttpRequest request, String data) {
        String response = String.format("<html><body>Posted<pre id=\"postData\">%s</pre></body></html>", data);
        this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.HTML, response);
    }

    protected void handleGet(HttpRequest request) throws IOException {
        String path = request.getRelativePath();
        File file = new File(this.wwwRoot, path);
        if (!file.exists()) {
            String data = "<html><body>Not found</body></html>";
            this.sendResponse(HTTP_STATUS.HTTP_FILE_NOT_FOUND, MIME.HTML, data);
        } else if (file.isFile()) {
            this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), file);
        } else {
            StringBuilder data = new StringBuilder();
            data.append("<html>\n<body>\n");
            data.append(String.format("<h1>Directory %s</h1>\n", request.getPath()));
            File parentDir = file.getParentFile();
            if (!file.equals(this.wwwRoot)) {
                if (parentDir.equals(this.wwwRoot)) {
                    data.append("<a href=\"/\">..</a><br/>\n");
                } else {
                    data.append(String.format("<a href=\"%s\">..</a><br/>\n", this.getRelativePath(parentDir)));
                }
            }
            for (File linkTo : file.listFiles()) {
                data.append(String.format("<a href=\"%s\">%s</a><br/>\n", this.getRelativePath(linkTo), linkTo.getName()));
            }
            data.append("</body>\n</html>");
            this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.HTML, data.toString());
        }
    }

    private String getRelativePath(File linkTo) {
        String path = linkTo.getAbsolutePath().substring(this.wwwRoot.getAbsolutePath().length());
        return path.replaceAll("\\\\", "/");
    }

    protected void sendResponse(HTTP_STATUS status, MIME mime, String data) {
        this.pw.print(String.format("HTTP/1.0 %s\n", new Object[]{status}));
        this.pw.write(String.format("Server: JSCover/%s\n", this.version));
        this.pw.write(String.format("Content-Type: %s\n", mime.getContentType()));
        this.pw.write(String.format("Content-Length: %d\n\n", data.length()));
        this.pw.write(data);
        this.pw.flush();
    }

    private void sendResponse(HTTP_STATUS status, MIME mime, File data) {
        this.pw.print(String.format("HTTP/1.0 %s\n", new Object[]{status}));
        this.pw.write(String.format("Server: JSCover/%s\n", this.version));
        this.pw.write(String.format("Content-Type: %s\n", mime.getContentType()));
        this.pw.write(String.format("Content-Length: %d\n\n", data.length()));
        this.pw.flush();
        this.ioUtils.copyNoClose(data, this.os);
    }

    protected void sendResponse(HTTP_STATUS status, MIME mime, InputStream is) {
        this.pw.print(String.format("HTTP/1.0 %s\n", new Object[]{status}));
        this.pw.write(String.format("Server: JSCover/%s\n", this.version));
        this.pw.write(String.format("Content-Type: %s\n\n", mime.getContentType()));
        this.pw.flush();
        this.ioUtils.copy(is, this.os);
    }
}

