/*
 * Decompiled with CFR 0.152.
 */
package jscover.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Socket;
import java.nio.charset.Charset;

public class IoUtils {
    private static IoUtils ioUtils = new IoUtils();
    public Charset charSet = Charset.defaultCharset();

    public static IoUtils getInstance() {
        return ioUtils;
    }

    public void closeQuietly(Closeable s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void closeQuietly(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString(InputStream is) {
        StringBuilder result = new StringBuilder();
        int bufSize = 1024;
        char[] buf = new char[bufSize];
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is, this.charSet));
            int read22 = 0;
            while ((read22 = br.read(buf)) != -1) {
                result.append(buf, 0, read22);
            }
            String read22 = result.toString();
            this.closeQuietly(br);
            return read22;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(br);
                throw throwable;
            }
        }
    }

    public String toStringNoClose(Reader reader, int length) {
        StringBuilder result = new StringBuilder();
        int bufSize = 1024;
        char[] buf = new char[bufSize];
        try {
            int read = 0;
            for (int total = 0; total < length && (read = reader.read(buf)) != -1; total += read) {
                result.append(buf, 0, read);
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString(File file) {
        try {
            return this.toString(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String loadFromClassPath(String dataFile) {
        InputStream is = null;
        try {
            is = IoUtils.class.getResourceAsStream(dataFile);
            String string = this.toString(is);
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Problem loading file: '%s'", dataFile), e);
        }
        finally {
            this.closeQuietly(is);
        }
    }

    public String loadFromFileSystem(File dataFile) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(dataFile);
            String string = this.toString(is);
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Problem loading file: '%s'", dataFile), e);
        }
        finally {
            this.closeQuietly(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(InputStream is, OutputStream os) {
        try {
            this.copyNoClose(is, os);
        }
        finally {
            this.closeQuietly(is);
            this.closeQuietly(os);
        }
    }

    public void copyNoClose(InputStream is, OutputStream os) {
        int bufSize = 1024;
        byte[] buf = new byte[bufSize];
        try {
            int read = 0;
            while ((read = is.read(buf)) != -1) {
                os.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyNoClose(File file, OutputStream os) {
        FileInputStream is = null;
        int bufSize = 1024;
        byte[] buf = new byte[bufSize];
        try {
            is = new FileInputStream(file);
            int read = 0;
            while ((read = ((InputStream)is).read(buf)) != -1) {
                os.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeQuietly(is);
        }
    }

    public void copy(Reader reader, File dest) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(dest);
            this.copy(reader, (OutputStream)os);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeQuietly(reader);
            this.closeQuietly(os);
        }
    }

    void copy(Reader reader, OutputStream os) {
        int bufSize = 1024;
        char[] buf = new char[bufSize];
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(os, this.charSet));
            int read = 0;
            while ((read = reader.read(buf)) != -1) {
                bw.write(buf, 0, read);
            }
            this.closeQuietly(reader);
            this.closeQuietly(bw);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(reader);
                this.closeQuietly(bw);
                throw throwable;
            }
        }
    }

    public void copy(String string, File dest) {
        ByteArrayInputStream bais = new ByteArrayInputStream(string.getBytes(this.charSet));
        this.copy((Reader)new InputStreamReader((InputStream)bais, this.charSet), dest);
    }

    public void copy(InputStream is, File dest) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(dest);
            this.copy(is, (OutputStream)os);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeQuietly(is);
            this.closeQuietly(os);
        }
    }

    public void copy(File src, File dest) {
        dest.getParentFile().mkdirs();
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(src);
            os = new FileOutputStream(dest);
            this.copy((InputStream)is, (OutputStream)os);
            this.closeQuietly(is);
            this.closeQuietly(os);
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(is);
                this.closeQuietly(os);
                throw throwable;
            }
        }
    }

    public String getRelativePath(File file1, File file2) {
        if (file1.equals(file2)) {
            return "";
        }
        return file1.getAbsolutePath().substring(file2.getAbsolutePath().length() + File.separator.length()).replaceAll("\\\\", "/");
    }

    public boolean isSubDirectory(File file1, File file2) {
        try {
            return (file1.getCanonicalPath() + File.separator).startsWith(file2.getCanonicalPath() + File.separator);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void copyDir(File src, File dest) {
        if (src.isDirectory()) {
            for (String file : src.list()) {
                this.copyDir(new File(src, file), new File(dest, file));
            }
        } else {
            ioUtils.copy(src, dest);
        }
    }

    public void mkdirs(File dir) {
        dir.mkdirs();
    }
}

