/*
 * Decompiled with CFR 0.152.
 */
package jscover.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import jscover.util.IoUtils;

public class Logger {
    private static Logger instance = new Logger();
    private static File log;
    private IoUtils ioUtils = IoUtils.getInstance();
    private boolean loggedException;

    public static Logger getInstance() {
        return instance;
    }

    public static void setLogFile(File file) {
        if (file.exists()) {
            file.delete();
        }
        log = file;
    }

    public boolean isLoggedException() {
        return this.loggedException;
    }

    public void log(String message) {
        this.log(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message, Throwable t) {
        if (log == null) {
            if (t == null) {
                System.err.println(message);
                return;
            }
            throw new RuntimeException(t);
        }
        File file = log;
        synchronized (file) {
            PrintStream ps = null;
            try {
                ps = new PrintStream(new FileOutputStream(log, true));
                ps.println("-------------------------------------------------------------------------------");
                ps.println(message);
                if (t != null) {
                    this.loggedException = true;
                    t.printStackTrace(ps);
                }
                this.ioUtils.closeQuietly(ps);
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.ioUtils.closeQuietly(ps);
                    throw throwable;
                }
            }
        }
    }
}

