import os
from distutils.core import setup

# Yes, I'm ommiting windoze...
BSDs = ['FreeBSD', 'OpenBSD', 'NetBSD', 'DragonFlyBSD']
linux = ['Linux']
osx = ['Darwin']

def proper_etc_path():
    """
    Try to set the proper path for configuration files, depending
    on the operating system.

    FIXME: I'm not sure this would work fine, as this will be executed
    when running python setup.py sdist, not when installing from the
    source package.
    """
    os_name = os.uname()[0]
    if os_name in BSDs:
        return '/usr/local/etc/'
    if os_name in linux or os_name in osx:
        return '/etc/'    
    return ''

def proper_rc_path():
    """
    Similar to proper_etc_path(), returns the path where startup scripts
    should be placed
    """
    os_name = os.uname()[0]
    etc_path = proper_etc_path()
    if os_name in 'BSDs':
        return etc_path+'rc.d'
    if os_name in linux:
        return etc_path+'init.d'
    if os_name in osx:
        # FIXME: not sure about where startup scripts should be placed in
        # "stock" osx (no macports, no homebrew, etc)
        return etc_path
    return ''

setup(
    name='mailjam',
    version='0.1.1',
    author='Francisco de Borja Lopez Rio',
    author_email='borja@codigo23.net',
    packages=['mailjam'],    
    url='https://bitbucket.org/codigo23/mailjam',
    license='BSD licence, see LICENSE',
    description='Mailing lists management software',
    long_description=open('README').read(),
    scripts=['bin/mailjam-server', 'bin/mailjam-mta', 'bin/mailjam-cli'],
    data_files=[(proper_etc_path()+'mailjam', ['conf/mailjam.conf',
                                               'conf/mailjam-mta.conf',
    					       'conf/mailjam-cli.conf']),
                (proper_rc_path(), ['bin/rc.d/mailjam'])]
)
