
from urllib2 import (
    Request, urlopen, build_opener, install_opener, HTTPCookieProcessor
    )
from urllib import urlencode
from urlparse import urljoin


class HTTPClient(object):

    def __init__(self, base_url):
        self.base_url = base_url
        self.request = build_opener(HTTPCookieProcessor())
        install_opener(self.request)

    def send_request(self, url, data=None):
        response = self.request.open(url, data)
        return response.read()

    def get(self, url):
        return self.send_request(urljoin(self.base_url, url))

    def post(self, url, data):
        encoded_data = urlencode(data)
        return self.send_request(urljoin(self.base_url, url), encoded_data)
