# -*- coding: utf-8 -*-

import sys, email, smtplib
from datetime import datetime
from models import MailingList
import config

class Sendmail():
    
    def __init__(self, mailing_list=None):
        if not isinstance(mailing_list, MailingList):
            raise ValueError(mailing_list, ' is not a valid mailing list')
        self.mailing_list = mailing_list
        self.suscriptors = self.mailing_list.members_addresses
        self.reply_to = self.mailing_list.address
        self.raw_email = None
        self.queue = []
        self.archive = self.mailing_list.config.get('archive',
                                                    config.archive_path)
        
    def get_raw_email(self):
        try:        
            self.raw_email = sys.stdin.read()
        except:
            raise IOError('Can not get a valid email from stdin')
        return self.raw_email

    def save_raw_email(self):
        if not self.raw_email:
            # FIXME: perhaps a while loop here, with some maximum recursion
            # check, would be nice here
            self.get_raw_email
        filename = os.path.join(self.archive,
                                datetime.today().strftime('%Y%d%m%H%M%S%f'))
        tmpfile = file(filename, 'w')
        tmpfile.write(self.raw_email)
        tmpfile.close()
        self.queue.append(filename)

    def send_email(self):
        if self.queue:
            next_email = self.queue.pop()
            email_file = file(next_email, 'r')
            email_data = email.message_from_file(email_file)
            email_file.close()

            email_data['Reply-to'] = self.reply_to

            smtp_conn = smtplib.SMTP()
            smtp_conn.connect()
            smtp_conn.sendmail(email_data['From'], self.suscriptors,
                               email_data.as_string())
            smtp_conn.close()

    def run(self):
        self.get_raw_email()
        self.save_raw_email()
        self.send_email()
