# -*- coding: utf-8 -*-

import os
from ConfigParser import SafeConfigParser

def get_config_parameters(section=None, configfile=None):
    if not configfile:
        # If there is no config file defined, try with the usual places
        # for config files, if there is no config file there, try to load
        # the one provided with postman sources
        default_paths = ['/usr/local/etc/postman/postman.conf',
                         '/usr/local/etc/postman.conf',
                         '/etc/postman/postman.conf',
                         '/etc/postman.conf',
                         os.path.join(os.path.dirname(__file__),
                                      '../conf/postman.conf')]
        for path in default_paths:
            if os.path.exists(path):
                configfile = path
                break
            
    # if there is no config file now, raise an exception, as we need one
    if not configfile:
        raise IOError('ERROR - Can not find postman.conf in your environment')

    available_sections = ['xmlrpc_server', 'storage', 'archive',
                          'mailing_lists', 'members']

    config = {}

    parser = SafeConfigParser()
    # FIXME: we should check here if the config file has been read correctly,
    # instead of letting an exception to pass through
    parser.read(configfile)

    if section in available_sections:
        for name, value in parser.items(section):
            config[name] = value
        return config

    # if no section (or an invalid section) is provided, return an empty config
    # set
    return config


# The default path for storage files
storage_path = os.path.join(os.path.dirname(__file__), 'storage')

# The default path for the archives
archive_path = os.path.join(os.path.dirname(__file__), 'archives')

# Set to True to set that, by default, only emails from members
# will go into the list
private_mailing = True
