import os
from distutils.core import setup

def proper_etc_path():
    # Yes, I'm ommiting windoze...
    BSDs = ['FreeBSD', 'OpenBSD', 'NetBSD', 'DragonFlyBSD']
    linux = ['Linux']
    osx = ['Darwin']
    os_name = os.uname()[0]
    if os_name in BSDs:
        return '/usr/local/etc/'
    if os_name in linux or os_name in osx:
        return '/etc/'    

setup(
    name='mailjam',
    version='0.1.0',
    author='Francisco de Borja Lopez Rio',
    author_email='borja@codigo23.net',
    packages=['mailjam'],
    url='https://bitbucket.org/codigo23/mailjam',
    license='BSD licence, see LICENCE',
    description='Mailing lists management software',
    long_description=open('README').read(),
    scripts=['bin/mailjam-server', 'bin/mailjam-mta', 'bin/mailjam-cli'],
    #data_files=[(proper_etc_path()+'mailjam', ['conf/mailjam.conf',
    #                                           'conf/mailjam-mta.conf']),
    #            ]
)
